//~~~~~~~~~~~~~~~~~~~~~~~~~~~
#include <gc.h>                 
#include <mathlib.h>            
//~~~~~~~~~~~~~~~~~~~~~

/******************************************************************************
*
*  Render_barsmpte
*
*******************************************************************************
*  Draws SMPTE bars.
*
*******************************************************************************
*  Usage:
*     Render_barsmpte( TGC* gc );
*
*  Arguments:
*     gc - the graphics context being drawn on.
*
*  Returns:
*     bool completed - true if the image could be drawn.
*                    - false if it can't be drawn.
*
*******************************************************************************
*/
bool Render_barsmpte( TGC* gc )
{
  INT32 w, y, i ;
  INT32 color[7] ;
  TMathLibrary ml;

  //*** This image has no "alternate" versions
  gc->Versions( 0 );

  //*** Setup the LUT and clear the canvas (screen)
  gc->SetLut( BW|HUEPEN|HUEIQ|GRAYEND|GRAYPEN|NOGAMMA );
  gc->ZeroActive();

  //*** Gather some colors together (makes it easier to do loops)
  color[0] = TStdColor::gray75;
  color[1] = TStdColor::yellow75;
  color[2] = TStdColor::cyan75;
  color[3] = TStdColor::green75;
  color[4] = TStdColor::magenta75;
  color[5] = TStdColor::red75;
  color[6] = TStdColor::blue75;

  //--------------------------------------------------------
  // Render the top set of bars
  //--------------------------------------------------------

  //*** Calculate the width of the bars
  w = gc->width / 7;

  //*** First, just render the the top line of each bar
  for( i = 0; i < 7; i++ )
  {
    gc->Transparent( color[i] );
    gc->FillRect   ( w, 1, i * w, 0 );
  }

  //*** Second, quickly fill in the remaining lines using the first line
  //*** Fast mode disables any time consuming pixel processing, which we
  //*** don't need in this simple case.
  gc->FastMode( true );
  gc->CurtainFillRect( gc->width, ml.Round( (double)gc->height * 0.67), 0, 0, 0 );
  gc->FastMode( false );

  //--------------------------------------------------------
  // Render the middle and bottom set of bars in a similar fashion
  //  1) draw the first line of the bars
  //  2) quickly fill in the remaining lines
  //--------------------------------------------------------
  
  y = ml.Round( (double)gc->height * 0.67 );
  gc->Opaque     ( TStdColor::black, TStdColor::black );
  gc->DrawLine   ( gc->left, y, gc->right, y );
  gc->FillRect   ( gc->width, 1, 0, y );
  gc->Transparent( color[6] );
  gc->FillRect   ( w, 1, w * 0, y );
  gc->Transparent( color[4] );
  gc->FillRect   ( w, 1, w * 2, y );
  gc->Transparent( color[2] );
  gc->FillRect   ( w, 1, w * 4, y );
  gc->Transparent( color[0] );
  gc->FillRect   ( w, 1, w * 6, y );

  gc->FastMode( true );
  gc->CurtainFillRect( gc->width, ml.Round( (double)gc->height * 0.08), 0, y, 0 );
  gc->FastMode( false );

  y = ml.Round( (double)gc->height * 0.75 );
  w = gc->width * 5 / 7 / 4;
  gc->Opaque     ( TStdColor::black, TStdColor::black );
  gc->DrawLine   ( gc->left, y, gc->right, y );
  gc->Transparent( TStdColor::huenegI );
  gc->FillRect   ( w, 1, w * 0, y );
  gc->Transparent( TStdColor::white );
  gc->FillRect   ( w, 1, w * 1, y );
  gc->Transparent( TStdColor::hueQ );
  gc->FillRect   ( w, 1, w * 2, y );

  w = (gc->width / 7) / 3;
  gc->Transparent( TStdColor::grayminus4 );
  gc->FillRect   ( w, 1, w * 15, y );
  gc->Transparent( TStdColor::gray5 );
  gc->FillRect   ( w, 1, w * 17, y );

  gc->FastMode( true );
  gc->CurtainFillRect( gc->width, gc->height - y, 0, y, 0 );

  //*** Return "true" to Indicate the image was rendered successfully
  return true;
}
